# Remotion Drag-and-Drop Renderer Setup

Complete setup guide for rendering TSX files to MP4 videos using Remotion.
Full Instructions at https://aicontroversy.com/tsx-to-mp4-video-renderer

## Prerequisites

1. **Node.js** (v16 or later)
   - Download from [nodejs.org](https://nodejs.org)
   - Verify installation: `node --version`

2. **npm or yarn** (comes with Node.js)
   - Verify: `npm --version`

## Output

- **Location**: `./rendered-videos/` (configurable)
- **Format**: MP4 (H.264)
- **Quality**: CRF 18 (visually lossless)
- **Compatibility**: Compatible with CapCut, DaVinci Resolve, and all major video editors

## Next Steps

1. Test with the provided `ExampleVideo.tsx` located in sample tsx folder
2. Create your own video components
3. Integrate with your stock analysis Python scripts
4. Automate batch rendering of multiple videos

## Resources

- [Remotion Documentation](https://www.remotion.dev/docs)
- [Remotion Examples](https://github.com/remotion-dev/remotion/tree/main/packages/example)
- [React Documentation](https://react.dev)