@echo off
REM Remotion TSX Drag-and-Drop Renderer
REM Drag your .tsx files onto this batch file to render them

setlocal enabledelayedexpansion

echo ========================================
echo   Remotion TSX Renderer aicontroversy.com
echo ========================================
echo.

REM Check if a file was dragged onto the batch file
if "%~1"=="" (
    echo ERROR: No file provided!
    echo.
    echo Usage: Drag and drop your .tsx file onto this batch file
    echo.
    pause
    exit /b 1
)

REM Get the full path of the dragged file
set "TSX_FILE=%~1"
set "FILE_EXT=%~x1"

REM Validate file extension
if /i not "%FILE_EXT%"==".tsx" (
    echo ERROR: Invalid file type!
    echo This script only accepts .tsx files
    echo You provided: %FILE_EXT%
    echo.
    pause
    exit /b 1
)

REM Check if file exists
if not exist "%TSX_FILE%" (
    echo ERROR: File not found: %TSX_FILE%
    echo.
    pause
    exit /b 1
)

echo Input file: %TSX_FILE%
echo.

REM Set output directory (same location as the batch file)
set "OUTPUT_DIR=%~dp0rendered-videos"

REM Check if Node.js is installed
where node >nul 2>nul
if errorlevel 1 (
    echo ERROR: Node.js is not installed or not in PATH
    echo Please install Node.js from https://nodejs.org
    echo.
    pause
    exit /b 1
)

REM Check if render script exists
set "RENDER_SCRIPT=%~dp0render-remotion.js"
if not exist "%RENDER_SCRIPT%" (
    echo ERROR: render-remotion.js not found!
    echo Please ensure render-remotion.js is in the same directory as this batch file
    echo Looking for: %RENDER_SCRIPT%
    echo.
    pause
    exit /b 1
)

REM Run the rendering script
echo Starting render process...
echo.
node "%RENDER_SCRIPT%" "%TSX_FILE%" "%OUTPUT_DIR%"

REM Check if rendering was successful
if errorlevel 1 (
    echo.
    echo ========================================
    echo   Rendering FAILED
    echo ========================================
    echo.
    pause
    exit /b 1
) else (
    echo.
    echo ========================================
    echo   Rendering SUCCESSFUL
    echo ========================================
    echo.
    echo Opening output folder...
    explorer "%OUTPUT_DIR%"
)

echo.
pause